<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\VisitorAttendance;
use App\Models\Visitor;
use App\Models\Product;
use App\Models\Purchase;
use App\Models\PtPurchase;
use App\Models\Instruktur;
use Illuminate\Support\Facades\DB;


class VisitorAttendanceController extends Controller
{
    public function add($id)
    {
        VisitorAttendance::create([
            'visitor_id' => $id,
            'tanggal' => date('Y-m-d'),
            'jam_masuk' => date('H:i'),
        ]);
        return back()->with('success', 'Kunjungan visitor dicatat!');
    }

    public function rekap(Request $request)
    {
        $tanggal_awal = $request->tanggal_awal ?? date('Y-m-01');
        $tanggal_akhir = $request->tanggal_akhir ?? date('Y-m-d');
    
        $rekap = \DB::table('visitors')
            ->select(
                'visitors.id',
                'visitors.nama',
                'visitors.kontak',
                'visitors.alamat',
                // Jumlah kunjungan
                \DB::raw('(SELECT COUNT(*) FROM visitor_attendances 
                            WHERE visitor_attendances.visitor_id = visitors.id 
                            AND tanggal BETWEEN "'.$tanggal_awal.'" AND "'.$tanggal_akhir.'"
                        ) as jumlah_kunjungan'),
                // Pendapatan dari attendance SAJA
                \DB::raw('(SELECT COALESCE(SUM(harga),0) FROM visitor_attendances 
                            WHERE visitor_attendances.visitor_id = visitors.id 
                            AND tanggal BETWEEN "'.$tanggal_awal.'" AND "'.$tanggal_akhir.'"
                        ) as total_pendapatan')
            )
            ->get();
    
        return view('visitor_attendance.rekap', [
            'rekap' => $rekap,
            'tanggal_awal' => $tanggal_awal,
            'tanggal_akhir' => $tanggal_akhir
        ]);
    
    }
    
   
    public function visit_mandiri(Request $request, $visitor_id)
    {
        // Ambil harga dari product (visit_only)
        $product = \DB::table('products')->where('nama', 'visit_only')->first();
        $harga = $product ? (int)$product->harga : 0;
        $bayar = (int) $request->bayar;
        $kembalian = max($bayar - $harga, 0);
    
        $now = now();
    
        $attendance_id = \DB::table('visitor_attendances')->insertGetId([
            'visitor_id'     => $visitor_id,
            'tanggal'        => $now->toDateString(),
            'jam_masuk'      => $now->toTimeString(),
            'harga'          => $harga,
            'bayar'          => $bayar,
            'kembalian'      => $kembalian,
            'payment_method' => $request->payment_method,
            'created_at'     => $now,
            'updated_at'     => $now,
        ]);
    
        return redirect()->route('visitor_attendance.struk_mandiri', $attendance_id);
    }

    public function visit_pt(Request $request, $visitor_id)
    {
        // Ambil harga produk PT dari tabel products
        $product = \DB::table('products')->where('id', $request->produk_id)->first();
        $harga_pt = $product ? (int)$product->harga : 0;
    
        // Ambil harga visit_only
        $visit_only = \DB::table('products')->where('nama', 'visit_only')->first();
        $harga_visit_only = $visit_only ? (int)$visit_only->harga : 0;
    
        // Total yang harus dibayar user
        $total_bayar = $harga_pt + $harga_visit_only;
    
        // Kembalian (jaga-jaga jika user bayar lebih)
        $bayar = (int)$request->bayar;
        $kembalian = max($bayar - $total_bayar, 0);
    
        // 1. Simpan ke pt_purchases (HANYA HARGA PT)
        $ptPurchaseId = \DB::table('pt_purchases')->insertGetId([
            'visitor_id'     => $visitor_id,
            'produk_id'      => $request->produk_id,
            'instruktur_id'  => $request->instruktur_id,
            'tanggal'        => $request->tanggal,
            'harga'          => $harga_pt, // <-- hanya harga PT!
            'bayar'          => $bayar,
            'kembalian'      => $kembalian,
            'payment_method' => $request->payment_method,
            'created_at'     => now(),
            'updated_at'     => now(),
        ]);
    
        // 2. Simpan ke visitor_attendances untuk biaya masuk
        \DB::table('visitor_attendances')->insert([
            'visitor_id'     => $visitor_id,
            'tanggal'        => $request->tanggal,
            'jam_masuk'      => now()->toTimeString(),
            'harga'          => $harga_visit_only,
            'bayar'          => 0, // Atur sesuai kebutuhan
            'kembalian'      => 0,
            'payment_method' => $request->payment_method,
            'created_at'     => now(),
            'updated_at'     => now(),
        ]);
    
        return redirect()->route('visitor.struk_pt', $ptPurchaseId)
            ->with('success', 'Transaksi Personal Trainer berhasil disimpan!');
    }


public function strukMandiri($attendance_id)
{
    // pastikan relasi visitor ada di model
    $attendance = VisitorAttendance::with('visitor')->findOrFail($attendance_id);

    return view('visitor.struk_mandiri', compact('attendance'));
}

public function strukPT($id)
{
    $trx = \App\Models\PtPurchase::with(['visitor', 'member', 'product', 'instruktur'])->findOrFail($id);
    return view('pt_purchases.print', compact('trx'));
}

public function struk_pt($ptPurchaseId)
{
    $pt = \DB::table('pt_purchases')->where('id', $ptPurchaseId)->first();
    $visitor = \DB::table('visitors')->where('id', $pt->visitor_id)->first();
    $attendance = \DB::table('visitor_attendances')
        ->where('visitor_id', $pt->visitor_id)
        ->where('tanggal', $pt->tanggal)
        ->first();
    //nama produk
    $pt = \DB::table('pt_purchases')
    ->join('products', 'pt_purchases.produk_id', '=', 'products.id')
    ->select('pt_purchases.*', 'products.nama as produk_nama')
    ->where('pt_purchases.id', $ptPurchaseId)
    ->first();
    // Jika ingin nama instruktur tampil:
    $pt->instruktur_nama = \DB::table('instrukturs')->where('id', $pt->instruktur_id)->value('nama');

    return view('visitor.struk_pt', compact('pt', 'visitor', 'attendance'));
}

    
}